//---------------------------------------------------------------------------
// Sample code for uM-FPU64 64-bit FLoating Point Coprocessor
// Micromega Corporation  www.micromegacorp.com
// Author: Cam Thompson
//
// @file    Read_GPRMC
// @target  Arduino
//
// This example provides a simple demonstration of reading GPS data using the
// uM-FPU64 64-bit floating point coprocessor. It reads latitude and longitude
// from the first GPRMC sentence and displays it on the Serial Monitor.
//
// It requires the functions contained one of the following FPU files be
// programmed into the uM-FPU64 Flash memory:
//   Read_GPRMC-demo1.fp4
//   Read_GPRMC-demo2.fp4
//
// The GPS serial input is connected to the digital pin specified by GPS_PIN
// in the FPU file (default assignment is D0).
//
// @version
//  Mar 25, 2013
//  - original version for uM-FPU64
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- uM-FPU Register Definitions -----------------------------
#define latitude    140                 // uM-FPU register
#define longitude   141                 // uM-FPU register

//-------------------- uM-FPU Function Definitions -----------------------------
#define read_GPRMC      0               // uM-FPU user function
#define NMEA_to_degrees 1               // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);                   // print program title
  Serial.println();
  Serial.println("\nRead_GPRMC");
  
  SPI.begin();                          // initialize SPI and FPU
  Fpu.begin();


  if (Fpu.sync() == SYNC_CHAR)          // print FPU version
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ;                          // stop if FPU not detected
  }

  Serial.print("Waiting for GPRMC sentence...");
  
  Fpu.write(FCALL, read_GPRMC);         // read lat/long from GPS
  Fpu.wait();
  
  Serial.println();
  FpuSerial.printStringln();            // display the GPRMC sentence
    
  Fpu.write(STRSET, 0);                 // print results
  Serial.print("Lat: ");
  
  Fpu.write(SELECTA, latitude);
  FpuSerial.printFloat(149);
  
  Serial.print(", Long: ");
  
  Fpu.write(SELECTA, longitude);
  FpuSerial.printFloatln(149);
  
  Serial.print("\nDone.");
}

//-------------------- loop -------------------------------------------------

void loop()
{ 
}

